<?php
/**
 * MachForm
 * 
 * © 2007–2025 Appnitro Software. All rights reserved.
 * 
 * This source code is proprietary and may not be copied, modified,
 * or distributed in any form without express written permission from Appnitro Software.
 * 
 * License information: https://www.machform.com/license-agreement/
 */
	require('config.php');
	require('lib/db-session-handler.php');
	require('includes/init.php');
	require('includes/db-core.php');
	require('includes/helper-functions.php');
	require('includes/check-session.php');

	$_POST = json_decode(file_get_contents('php://input'), true);

	$csrf_token 	= trim($_POST['csrf_token'] ?? '');

	//validate CSRF token
	mf_verify_csrf_token($csrf_token);

	//check user privileges, is this user has privilege to administer MachForm?
	if(empty($_SESSION['mf_user_privileges']['priv_administer'])){
		die("You don't have permission to administer MachForm.");
	}

	$_SESSION['filter_users'] = array();
	unset($_SESSION['filter_users']);
	
	
	$response_data = new stdClass();
	$response_data->status    	= "ok";
	
	
	$response_json = json_encode($response_data);
	
	echo $response_json;
?>